//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate different Line Codes - 2(Manchestre)

clear;
close;
clc;
x=[1 0 1 0 0 1 1 0]//Data Stream

//Manchester
z=0;//Starting value on x axis
for i=1:length(x)
    t=[z:1:z+1]//Plot range on x-axis (One bit period)
        subplot(2,1,1)
        a=gca();
        a.data_bounds=[0,-1.5;length(x),1.5]
        a.grid=[1,-1]
        title('Data')
        plot(t,x(i))//Plot current data bit
    
    t=[z:0.5:z+0.5]//Plot range on x-axis (first half bit period)
        subplot(2,1,2)
        a=gca();
        a.data_bounds=[0,-1.5;length(x),1.5]
        a.grid=[1,-1]
        title('Manchester')
        if(x(i)==0)
            plot(t,1)//Plot 1 for first half bit duration
            t=[z+0.5:0.5:z+1]//Plot range on x-axis (second half bit period)
            plot(t,-1)//Plot 1 for second half bit duration
        else
            plot(t,-1)//Plot -1 for first half bit duration
            t=[z+0.5:0.5:z+1]//Plot range on x-axis (second half bit period)
            plot(t,1)//Plot 1 for second half bit duration
        end
    z=z+1;//Increament starting value on x axis by one bit period
end

